#version 150 compatibility 

in vec4 color ;
in vec3 light_dir ;
in vec3 normal ;

in float var_z ;

uniform vec3 uni_bottom_color ; // the bottom color, should stay constant.
uniform vec3 uni_sky_color_1 ; // used through out the demo
uniform vec3 uni_sky_color_2 ; // used at the end in the outro

/// Used for mixing the sky color 1 with sky color2
uniform float uni_mix_color_1_2 ;

void main()
{
	float ndl = dot(light_dir,normal) ;

	vec3 sky_color = mix(uni_sky_color_1, uni_sky_color_2, uni_mix_color_1_2) ;
	vec3 bottom_color = mix(uni_bottom_color, uni_bottom_color, uni_mix_color_1_2) ;

	vec3 sphere_color = mix(bottom_color, sky_color, ndl * 0.5 + 0.5) ;

	sphere_color = mix(sphere_color, sky_color, vec3(var_z)) ;

	gl_FragData[0] = vec4(sphere_color,1.0) ; //vec4(ndl)*vec4(0.0,1.0,0.0,1.0) ;
	gl_FragData[1] = vec4(1.0) ;

	//gl_FragData[0] = vec4(0.0);
}